//
//  MTEAudioFile.h
//  MTEditorFW
//
//  Created by liu hengzhuo on 8/18/12.
//  Copyright (c) 2012 liu hengzhuo. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MTEDefines.h"

typedef enum ESAudioFileStatus_ {
    ESAudioFileClean,  // 等待被编辑
    ESAudioFileDirty,  // 已经被编辑过了
    ESAudioFileWarning,  // 已经被成功保存
    ESAudioFileFailed,
} ESAudioFileStatus;

/*
 所有音频格式文件的基类
 */
@interface MTEAudioFile : NSObject <NSCoding,NSCopying> {
    NSMutableDictionary * dicReadInfo;
    NSMutableDictionary * dicMap;
}

+ (NSData *)image:(NSImage *)aImg dataRepresentationOfType:(NSString *)aType;

@property (retain) NSMutableDictionary * dicReadInfo;
@property (retain) NSMutableDictionary * dicMap;

@property (assign) ESAudioFileStatus status;

@property (readwrite,copy) NSString * filePath;
@property (readonly) NSString * fileName;  // 文件名，方便外部访问
@property (readwrite,assign) MTEAudioFileType eumFileType;

@property (readwrite,copy) NSString * renameTokenStr;
@property (readwrite,copy) NSString * dateFmt;

@property (readwrite,copy) NSString * fileKind;

// 判断当前编码是否改变
@property (assign) BOOL encodingChanged;
@property (assign) BOOL bTrackNumAuto;

#pragma mark 文件本身属性,外部只读
@property (assign) int bitrate;
@property (assign) int channels;
@property (assign) int sampleRate;

@property (readwrite,assign) double duration;
@property (readwrite,copy) NSString * strTagVersion;   // only for mpeg files
@property (readwrite,assign) EMpegFileID3Version eumID3Version;
@property (readwrite,copy) NSString * strMineType;

#pragma mark 全部需要的 metaData information from taglib
@property (readwrite,retain) NSMutableArray * albumImg;    // 专辑封面
@property (readwrite,copy) NSString * title;        // 歌曲 title
@property (readwrite,copy) NSString * artist;       // 艺术家
@property (readwrite,copy) NSString * albumArtist;
@property (readwrite,copy) NSString * album;
@property (readwrite,copy) NSString * date;
@property (readwrite,copy) NSString * genre;
@property (readwrite,copy) NSString * publisher;
@property (readwrite,copy) NSString * composer;
@property (readwrite,copy) NSString * copyright;
@property (readwrite,copy) NSString * comment;
@property (readwrite,copy) NSString * lyric;

// 01/10 
@property (readwrite,copy) NSString * track;

// new 2.2.0
@property (readwrite,copy) NSString * discNumber;
@property (readwrite,copy) NSString * grouping;

// 将该文件tag 信息编码转换到制定编码
- (void)convertToEncoding:(NSStringEncoding)stringEncoding;

/*
 读取 tag 信息
 */
- (void)dumpMediaAttribInfo:(NSError **)outError;

- (void)restoreFromLocal;

// newPath 必须存在，可以是原文件路径，也可以是全新的文件路径
// 返回值表示是否需要进入下一层保存
- (BOOL)saveNew:(NSString *)newPath error:(NSError **)outError;

// 子类可以直接调用的方法,内部方法
// ID3 Tag Support
- (void)dumpID3V1Info:(void *)aid3v1tag;
- (void)dumpID3V2Info:(void *)aid3v2tag;
- (void)saveID3V2Info:(void *)aid3v2tag;

// APE Tag Support
- (void)dumpAPETagInfo:(void *)apeTag;
- (void)saveAPETagInfo:(void *)apeTag;

// Audio properties
- (void)dumpAudioPropeties:(void *)audioFile;

@end
